package com.ejie.ab04b.constantes;

import com.ejie.ab04b.control.TipoCambioImpl;
import com.ejie.ab04b.model.Tablones;

/**
 * Enumeration con los estados de la aplicacion
 * 
 * @author a
 */
public enum TipoCambio {

	COORD_EJEC_OBRA("CE"), MODIFICACION_APERTURA("MA"), SUBSANACION_APERTURA(
			"SA"), ELIMINACION_APERTURA("EL");

	private String codigo = null;

	// constructor interno
	/**
	 * Instantiates a new tipo cambio.
	 * 
	 *  codigo            int
	 *
	 * @param codigo the codigo
	 */
	private TipoCambio(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * Value.
	 * 
	 *  Integer
	 *
	 * @return the tablones
	 */
	public Tablones value() {
		return TipoCambioImpl.getInstance().getValue(this.name());
	}

	/**
	 * Gets the codigo.
	 * 
	 *  the codigo
	 *
	 * @return the codigo
	 */
	public String getCodigo() {
		return codigo;
	}

	/**
	 * Sets the codigo.
	 * 
	 *  codigo            the codigo to set
	 *
	 * @param codigo the new codigo
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

}
